/*:
 * @target MZ
 * @plugindesc [DEMO] Gacha Minigame for RPG MAKER MZ. (This plugin is a completely new and different version of https://undermax.itch.io/gacha-minigame)
 * @author Undermax Games | Maxii1996
 * @url https://undermax.itch.io/
 * @help
 *   _______________________________________________________________
 * 
 * 
 *          Plugin Version:          DEMO VERSION          
 *          Developed by:            Undermax | Maxii1996
 *          Web:                     https://undermax.itch.io
 * 
 *    _______________________________________________________________
 *                     
 *            _____            _                                      
 *           / ____|          | |                                     
 *          | |  __  __ _  ___| |__   __ _                            
 *          | | |_ |/ _` |/ __| '_ \ / _` |                           
 *          | |__| | (_| | (__| | | | (_| |                           
 *           \_____|\__,_|\___|_| |_|\__,_|                           
 *       __  __ _       _                              _____ _____ 
 *      |  \/  (_)     (_)                            |_   _|_   _|
 *      | \  / |_ _ __  _  __ _  __ _ _ __ ___   ___    | |   | |  
 *      | |\/| | | '_ \| |/ _` |/ _` | '_ ` _ \ / _ \   | |   | |  
 *      | |  | | | | | | | (_| | (_| | | | | | |  __/  _| |_ _| |_ 
 *      |_|  |_|_|_| |_|_|\__, |\__,_|_| |_| |_|\___| |_____|_____|
 *                         __/ |                        
 *                        |___/                        DEMO VERSION 
 * 
 *     ============================= CHANGE LOG =============================
 *
 * 
 *        (DEMO) INITIAL RELEASE - DEMO versions do not have updates.
 * 
 * 
 *     ============================ INTRODUCTION ============================ 
 *
 *  
 *   This plugin implements a customizable gacha system, allowing
 *   players to engage in random reward draws. It features multiple
 *   banners, configurable reward probabilities, animations, and
 *   guarantees, creating an engaging and dynamic experience.
 * 
 *     ============================ FULL VS DEMO ============================ 
 *
 *               The documentation for this plugin is also part of the FULL 
 *               version. Keep in mind that some features may not be available 
 *               here.
 *
 *               Detailed features and parameters of the DEMO VS FULL version:
 *
 *               Parameter:
 *
 *            -> Gachas
 *                 --> Apparance Conditions
 *                           ** DEMO: Not Available
 *                              (All banners are showed always)
 *                           ** FULL: Yes.
 *                      
 *                   --> Buttons
 *                       --> Activation Conditions
 *                           ** DEMO: Variables only (1)
 *                           ** FULL: Variables, Switch, Money
 *                               (Unlimited)
 *
 *               -> Reward Lists:
 *                   --> Rewards
 *                       --> Type
 *                           ** DEMO: Only Items, Weapons, Armors.
 *                           ** FULL: Items, Weapons, Armors, Money,
 *                               Variables.
 *
 *                       --> Quantity per Draw:
 *                           ** DEMO: Not available
 *                           ** FULL: Yes. Customizable with fixed values,
 *                               random, or variable amounts.
 *
 *                       --> Probability:
 *                           ** DEMO: Fixed number only
 *                           ** FULL: Fixed number with support for combined 
 *                               Variables.
 *
 *                       --> Skip this reward if...
 *                           ** DEMO: Not available
 *                           ** FULL: Available.
 *
 *                       --> Hide in Probability Window
 *                           ** DEMO: Not available
 *                           ** FULL: Available.
 * 
 *                       --> Play Common Event on Obtain
 *                           ** DEMO: Not available
 *                           ** FULL: Available. 
 *
 *                       --> ID Search Area
 *                           ** DEMO: Not included
 *                           ** FULL: Yes, included.
 *
 *               -> Rarity Animations
 *
 *                   --> Visual Highlight of Rewards
 *                       in the Reward window (When drawing)
 *                           ** DEMO: Not available
 *                           ** FULL: Yes. Customizable Gradient Fill or 
 *                               a small mark on the left side of the reward.
 *
 *               --> Guaranteed Rewards List:
 *                   (Allows securing rare rewards when making X amount of 
 *                   draws together, as is common in many games that 
 *                   guarantee an UR after X draws.)
 *
 *
 *               Other differences not present in the parameters:
 *
 *               - The code is slightly different for both versions and is
 *                  better optimized in the FULL version.
 *
 *               - Some formulas and actions work only in the FULL version 
 *                  of the plugin.
 *
 *               - The FULL version includes several BONUS video files for
 *                  you to use in your project!
 *
 *               - The DEMO version only includes 2 sample video files as 
 *                 a demo.
 *
 * 
 *                         :: Plugin Parameters ::
 *
 *   - Gachas: Defines the gacha banners. Each entry can have its own
 *      image, custom texts, buttons, and actions.
 * 
 *   -- Buttons: Configures the buttons for each gacha. Each button can
 *      trigger different actions (variables, switches, common events) and
 *      is associated with a Reward List via the same ReferenceID same.
 * 
 *      Example:
 *        [{"Text":"Draw One", "Actions":"...", "RewardsReference":"list1"}]
 *
 *   --- Conditions: Sets conditions for button availability, including
 *      variables, switches, and game states.
 * 
 *      Example:
 *        [{"ConditionType":"variable", "ID":1, "Operator":">", "Value":"10"}]
 *
 *      For example you can set this to disable a Gacha draw if player
 *      doesn't have enought money.
 * 
 *   --- Actions: Commands executed when a button is pressed, such as
 *      changing variables, switches, triggering common events, or 
 *      handling money.
 *   
 * 
 *         Available Commands:
 * 
 *            - variable(ID, +/-Value): Adjusts the value of a variable.
 *              Example: "variable(3, -5)"
 *              Use case: Deduct currency for a gacha draw.
 *
 *            - switch(ID, on/off): Sets a switch on or off.
 *             Example: "switch(5, on)"
 *
 *            - money(+/-Amount): Adds or removes player gold.
 *              Example: "money(-300)"
 *              Use case: remove gold when play the gacha.
 *
 *            - common_event(ID): Triggers a common event.
 *              Example: "common_event(4)"
 * 
 *      
 *   - Reward Lists: An array of possible rewards for each draw. Each 
 *      list is linked to buttons and defines the possible rewards with
 *      their probabilities and conditions.
 * 
 *      Example: 
 *        [{"ReferenceID":"list1", "Rewards":[...]}]
 * 
 *     >> The ReferenceID must be an unique identifier.
 *        For example: "GachaWeapons", "Items", "my_gacha1"
 * 
 *
 *   -- Probability Formulas: Calculates the probability of each reward
 *      dynamically. This formula can reference variables to create
 *      flexible and evolving probabilities.
 * 
 *      Example:
 *         "variable(15) + 10" or you can use fixed values: "50".
 * 
 *    - Quantity Per Draw:
 * 
 *      This sets how much of that item will be received each time 
 *      the reward is issued. For variables and money, you should use 
 *      this value to set the amount you want to award.
 * 
 *      It supports formulas, so you can write a fixed value or use:
 *
 *      Random Number:
 *
 *      random(x, y)
 *
 *      A number between x and y is chosen. Remember 
 *      to separate them with a comma.
 *
 *      Variable:
 *
 *       You can make it use the value of a variable by writing:
 *
 *       variable(id) where ID is the game variable whose
 *       value you want to retrieve.
 * 
 * 
 *      - Rarity Level:
 * 
 *       This sets the rarity level of the reward. This is directly
 *       linked to the videos that will be played and the guaranteed
 *       rewards. Make sure to assign the correct value to each item.
 * 
 *       I recommend using a numerical scale to facilitate the
 *       process. 
 * 
 *       For example:
 * 
 *      Items of low rarity might be "1", like a potion; an item of
 *      medium rarity might be "3"; and something legendary or of
 *      significant rarity "5".
 * 
 *      There is no limit to rarity levels; you can set them as you
 *      wish, but keep in mind that it will be important to have this
 *      well configured for each reward.
 * 
 *      Important: The rarity order is set from lowest to highest
 *      by the ARRAY INDEX, with those higher up being less rare than
 *      those below.
 *      You must maintain the order of priority you want to use, as
 *      the use of texts as rarity names is accepted, the order must
 *      be established somehow, and it was decided to do it this way.
 *
 * 
 *      -  Skip this reward if these conditions are met: (Skip Conditions)
 *    
 *        This ensures that this reward will never be received if these
 *        conditions are met.
 *    
 *        You can use the following conditions:
 *    
 *       switch(x) [Operator] [state]
 *       variable(x) [Operator] [value]
 *       money [Operator] [value]
 *    
 *       Examples:
 *    
 *       switch(1) = true
 *       In this case, the reward will not be given if switch 1 is active.
 *    
 *       variable(2) >= 10
 *       In this case, the reward will not be given if variable 2 is greater
 *       than or equal to 10.
 *    
 *       money <= 5000
 *       In this case, the reward will not be given if the player's money is
 *       less than 5000.
 * 
 * 
 *        - Hide in Probability Window
 *    
 *        This will hide the name of the reward on the Probability Screen
 *        (Shift Key) and replace it with the text defined in the "Text when
 *       Hidden" parameter.
 *    
 *       Reveal on Obtain
 *       This will reveal the name of the reward when it is obtained in the
 *       Gacha.
 * 
 *      -   ID Search Area:
 *    
 *      This has been added to make it easier for you when searching for the
 *      ID you need, so you don't have to keep opening and closing the database
 *      while configuring these values.
 *      It is intended to help the programmer and has no effect in the game.
 *      Use it simply as a guide.
 *
 * 
 *    Other Parameters:
 * 
 *    Transition Duration: Duration of the transitions between banners
 *      in frames. This provides smooth animations when switching between
 *      different gacha banners. Example: 15
 *
 *   - Scene Window Style: Defines the appearance of the gacha scene window. 
 *
 *   - Button Window Style: Configures the appearance of the button window
 *      in the gacha scene, allowing further visual customization.
 *
 *   - BackgroundImage: Adds a custom background image to the gacha scene.
 *
 * 
 *            NOTE BEFORE CLOSING:
 * 
 *            If you've want to upgrade to the FULL version of the plugin, 
 *            many functions in this plugin are different and work
 *            differently, including the priority order for video
 *            playback. So keep that in mind.
 * 
 *            How does the probability system work?
 * 
 *            The probability system is NORMALIZED AND AUTOMATED, meaning
 *            you don't need to worry about manually calculating the
 *            acquisition probabilities. Simply set the chances in the
 *            probability fields for that particular item, and the system
 *            will adjust it based on the number of items in the list and
 *            their individual probabilities.
 *            This means that if you want an item with a 1% chance of
 *            being obtained, it will be harder to get in a list of 20
 *            items, and a bit easier in a list of 5 items. So don't
 *            worry if you see that you set 10% probability and a
 *            different number appears in the list, as it is calculated
 *            dynamically.
 * 
 * 
 *
 *    ===================== END OF DOCUMENTATION==================== 
 *
 *
 * @command OpenGachaBanner
 * @text Open Gacha Banner
 * @desc Opens the Gacha banner scene for the player to interact with.
 * 
 * @param Gachas
 * @text Gachas
 * @desc List of gachas, each with its banner image, custom texts, and buttons.
 * @type struct<Gacha>[]
 * 
 * @param RewardLists
 * @text Reward Lists
 * @desc List of reward references for Gacha draws.
 * @type struct<RewardList>[]
 * @default []
 * 
 * @param BackgroundImage
 * @text Background Image
 * @type file
 * @dir img/pictures
 * @default
 * @desc Optional background image for the gacha banner scene. The image will be displayed above a black background.
 *
 * @param RarityAnimations
 * @text Rarity Animations
 * @desc Define animations (videos) linked to rarity levels. If at least one item has a matching rarity, the corresponding video will play.
 * @type struct<RarityAnimation>[]
 * 
 * @param BannerWidth
 * @text Banner Width
 * @desc Width of the banner in pixels.
 * @type number
 * @default 650
 *
 * @param BannerHeight
 * @text Banner Height
 * @desc Height of the banner in pixels.
 * @type number
 * @default 350
 *
 * @param BannerX
 * @text Banner X Position
 * @desc X position of the banner.
 * @type number
 * @default 0
 *
 * @param BannerY
 * @text Banner Y Position
 * @desc Y position of the banner.
 * @type number
 * @default -15
 *
 * @param SceneWindowStyle
 * @text Scene Window Style
 * @type select
 * @option Normal
 * @value 0
 * @option Borderless
 * @value 1
 * @default 0
 * @desc Choose whether the scene has window frame borders or not.
 *
 * @param DotSize
 * @text Dot Size
 * @desc Size of the dots in pixels.
 * @type number
 * @default 10
 *
 * @param DotSpacing
 * @text Dot Spacing
 * @desc Spacing between dots.
 * @type number
 * @default 15
 *
 * @param DotX
 * @text Dot X Position
 * @desc X position of the dots.
 * @type number
 * @default 0
 *
 * @param DotY
 * @text Dot Y Position
 * @desc Y position of the dots.
 * @type number
 * @default 500
 *
 * @param TransitionDuration
 * @text Transition Duration
 * @desc Duration of banner transitions in frames.
 * @type number
 * @default 15
 *
 * @param ButtonWindowStyle
 * @text Button Window Style
 * @type struct<ButtonWindowStyle>
 * @desc Customize the size, position, and style of the button window.
 * @default {"Width":"50","Height":"30","X":"25","Y":"75","WindowStyle":"2","DimGradientColors":"{\"TopColor\":\"rgba(0, 0, 0, 0.3)\",\"BottomColor\":\"rgba(0, 0, 0, 0)\"}"}
 *
 * @param RewardWindowSettings
 * @text Reward Window Settings
 * @desc Settings for the reward help text and window style.
 * @type struct<RewardWindowSettings>
 * @default {"HelpText":"These are the rewards you have obtained:","WindowStyle":"1","ManualDimSettings":"{\"TopColor\":\"rgba(50, 50, 50, 0.6)\",\"BottomColor\":\"rgba(0, 0, 0, 0.2)\"}"}
 * 
 * @param ProbabilityWindowSettings
 * @type struct<ProbabilityWindowSettings>
 * @text Probability Window Settings (Press Shift in the Gacha Main Screen)
 * @desc Settings for the Probability Window.
 * @default {"Width":"50","Height":"50.00","X":"25","Y":"25","WindowStyle":"1","DimGradientColors":"{\"TopColor\":\"rgba(0, 0, 0, 0.6)\",\"BottomColor\":\"rgba(0, 0, 0, 0)\"}"}
 * 
 */

/*~struct~Gacha:
 * @param BannerImage
 * @text Banner Image
 * @desc The image for this gacha banner.
 * @type file
 * @dir img/pictures/
 *
 * @param CustomTexts
 * @text Custom Texts
 * @desc Texts to be displayed on the banner.
 * @type struct<CustomText>[]
 *
 * @param Buttons
 * @text Buttons
 * @desc Buttons to select the number of draws and rewards reference for this gacha.
 * @type struct<Button>[]
 */

/*~struct~CustomText:
 * @param Text
 * @text Text
 * @desc The text to display.
 * @type string
 * @default Sample Text
 *
 * @param Color
 * @text Text Color
 * @desc The color of the text in CSS format (e.g. #FFFFFF for white).
 * @type string
 * @default #FFFFFF
 *
 * @param Size
 * @text Text Size
 * @desc The size of the text in pixels.
 * @type number
 * @default 24
 *
 * @param OffsetX
 * @text X Offset
 * @desc The X offset for the text from the center of the screen (in pixels).
 * @type number
 * @default 0
 *
 * @param OffsetY
 * @text Y Offset
 * @desc The Y offset for the text from the center of the screen (in pixels).
 * @type number
 * @default 0
 */

/*~struct~Button:
 * @param Text
 * @text Button Text
 * @desc The text to display on the button.
 * @type string
 * @default Button
 *
 * @param TextColor
 * @text Text Color
 * @desc The text color of the button in CSS format (e.g. #FFFFFF for white).
 * @type string
 * @default #FFFFFF
 *
 * @param ActivationVariable
 * @text Activation Variable
 * @desc The variable ID that controls whether the button is active.
 * @type variable
 *
 * @param ConditionalFormula
 * @text Conditional Formula
 * @desc The condition to check for activating the button (e.g. ">= 1").
 * @type string
 *
 * @param NumberOfDraws
 * @text Number of Draws
 * @desc The number of draws to perform when this button is pressed.
 * @type number
 *
 * @param RewardsReference
 * @text Rewards Reference
 * @desc The reference text for the rewards to use with this button.
 * @type string
 * @default
 * 
 * @param Actions
 * @text Button Actions
 * @desc Define an action like "variable(X, Y)" to modify variables. Example: variable(1, -100).
 * @type string
 * @default
 * 
 */

/*~struct~ButtonWindowStyle:
 * @param Width
 * @type number
 * @min 0
 * @max 100
 * @desc Set the button window width in percentage relative to screen width.
 * @default 100
 *
 * @param Height
 * @type number
 * @min 0
 * @max 100
 * @desc Set the button window height in percentage relative to screen height.
 * @default 25
 *
 * @param X
 * @type number
 * @desc X offset position of the button window in percentage relative to screen width.
 * @default 0
 *
 * @param Y
 * @type number
 * @desc Y offset position of the button window in percentage relative to screen height.
 * @default 0
 *
 * @param WindowStyle
 * @type select
 * @option Normal
 * @value 0
 * @option Dim
 * @value 1
 * @option Transparent
 * @value 2
 * @desc Style of the button window (0: Normal, 1: Dim, 2: Transparent)
 * @default 0
 *
 * @param DimGradientColors
 * @type struct<ColorArray>
 * @desc Set the gradient colors for the Dim style. Array with Top and Bottom colors.
 * @default {"TopColor":"rgba(0, 0, 0, 0.6)", "BottomColor":"rgba(0, 0, 0, 0)"}
 */

/*~struct~ColorArray:
 * @param TopColor
 * @type string
 * @desc The top color of the gradient in rgba format (e.g. rgba(0, 0, 0, 0.6)).
 * @default rgba(0, 0, 0, 0.6)
 *
 * @param BottomColor
 * @type string
 * @desc The bottom color of the gradient in rgba format (e.g. rgba(0, 0, 0, 0)).
 * @default rgba(0, 0, 0, 0)
 */

/*~struct~RewardList:
 * @param ReferenceID
 * @text Reference ID
 * @desc The unique identifier for this reward list.
 * @type string
 * @default
 *
 * @param Rewards
 * @text Rewards
 * @desc List of rewards in this reward list.
 * @type struct<Reward>[]
 * @default []
 *
 */



/*~struct~Reward:
 * @param Type
 * @text Type
 * @desc The type of the reward (Item, Weapon, Armor).
 * @type select
 * @option Item
 * @value item
 * @option Weapon
 * @value weapon
 * @option Armor
 * @value armor
 * @default item
 *
 * @param ID
 * @text ID
 * @desc The ID of the item/weapon/armor.
 * @type number
 * @default 1
 *
 * @param Probability
 * @text Probability
 * @desc The probability (1-100) of obtaining this item.
 * @type number
 * @min 1
 * @max 100
 * @default 50
 * 
 * @param Rarity
 * @text Rarity Level
 * @desc The rarity level of this reward (e.g., 1 = common, 2 = rare, etc.).
 * @type string
 * @default 1
 *
 */

/*~struct~RewardWindowSettings:
 * @param HelpText
 * @text Reward Help Text
 * @desc The text displayed at the top of the reward window.
 * @type string
 * @default These are the rewards you have obtained:
 *
 * @param WindowStyle
 * @text Reward Window Style
 * @type select
 * @option Normal
 * @value 0
 * @option Dim
 * @value 1
 * @option Transparent
 * @value 2
 * @desc Choose the style of the window (0: Normal, 1: Dim, 2: Transparent)
 * @default 0
 * 
 * @param ManualDimSettings
 * @text Manual Dim Settings
 * @desc Custom gradient colors for the Dim style background.
 * @type struct<ManualDimSettings>
 * @default {"TopColor": "rgba(50, 50, 50, 0.8)", "BottomColor": "rgba(0, 0, 0, 0.2)"}
 */


/*~struct~ManualDimSettings:
 * @param TopColor
 * @text Dim Top Color
 * @desc The top color of the gradient for the manual dim setting in rgba format.
 * @type string
 * @default rgba(50, 50, 50, 0.8)
 *
 * @param BottomColor
 * @text Dim Bottom Color
 * @desc The bottom color of the gradient for the manual dim setting in rgba format.
 * @type string
 * @default rgba(0, 0, 0, 0.2)
 */




/*~struct~RarityAnimation:
 * @param RarityLevel
 * @text Rarity Level
 * @desc The rarity level identifier (e.g., 1, 2, 'rare', etc.).
 * @type string
 * @default 1
 *
 * @param VideoFile
 * @text Video File
 * @desc The video file to play when this rarity level is obtained.
 * @type string
 * @default
 */

/*~struct~ProbabilityWindowSettings:
 *
 * @param Width
 * @type number
 * @decimals 2
 * @min 0
 * @max 100
 * @desc Width of the probability window, as a percentage of the screen width.
 * @default 50
 *
 * @param Height
 * @type number
 * @decimals 2
 * @min 0
 * @max 100
 * @desc Height of the probability window, as a percentage of the screen height.
 * @default 50
 *
 * @param X
 * @type number
 * @decimals 2
 * @min 0
 * @max 100
 * @desc X position of the probability window, as a percentage of the screen width.
 * @default 25
 *
 * @param Y
 * @type number
 * @decimals 2
 * @min 0
 * @max 100
 * @desc Y position of the probability window, as a percentage of the screen height.
 * @default 25
 *
 * @param WindowStyle
 * @type select
 * @option Default
 * @value 0
 * @option No Frame with Dim Gradient
 * @value 1
 * @option Transparent
 * @value 2
 * @desc Window style for the probability window.
 * @default 0
 *
 * @param DimGradientColors
 * @type struct<ProbabilityDimGradientColors>
 * @desc Gradient colors for the dim background when WindowStyle is set to No Frame with Dim Gradient.
 */

/*~struct~ProbabilityDimGradientColors:
 *
 * @param TopColor
 * @type string
 * @desc Top color of the gradient for the probability window. Use CSS color format.
 * @default rgba(0, 0, 0, 0.6)
 *
 * @param BottomColor
 * @type string
 * @desc Bottom color of the gradient for the probability window. Use CSS color format.
 * @default rgba(0, 0, 0, 0)
 */


function _0x5c0b(_0x163ee5,_0x5473a3){const _0x3f472c=_0x3f47();return _0x5c0b=function(_0x5c0b64,_0x40dbd6){_0x5c0b64=_0x5c0b64-0x1d9;let _0x30753e=_0x3f472c[_0x5c0b64];return _0x30753e;},_0x5c0b(_0x163ee5,_0x5473a3);}function _0x3f47(){const _0x324ef1=['showRewardScreen','cancel','Gachas','armor','absolute','clear','push','isCommandEnabled','1685hMgbtU','video','applySceneWindowStyle','weapon','textWidth','RarityAnimations','toLowerCase','pagedown','get','changePaintOpacity','maxItems','deactivate','autoplay','GachaMinigame2DEMO','itemRect','ended','helpWindowRect','isTriggered','drawItem','createPageButtons','contains','93742SVrSqs','auto','_isFadingOut','playRarityVideo','_transitionDirection','startFadeIn','OffsetX','DimGradientColors','_manualDimSettings','reduce','260IePNBQ','Size','DotY','body','webkit-playsinline','applyDimGradient','createBackground','968068aNexoL','drawText','128fpCjck','startTransition','WindowStyle','refresh','frameVisible','_cancelButton','max','activate','preventDefault','DotSize','getRewardName','contextmenu','setBackgroundType','set','Actions','Buttons','convertEscapeCharacters','start','_sceneRewards','_isVideoPlaying','BannerY','createDots','rgba(0,\x200,\x200,\x200.6)','gradientFillRect','currentTime','Unknown\x20Weapon','performGachaDraw','setButtons','_customTexts','_buttons','_rewardsToShow','BannerX','setText','applyProbabilityDimGradient','Text','playsinline','rewardWindowRect','muted','setCustomTexts','drawRewardIcon','ReferenceID','_fadeDuration','cover','left','mouseup','map','Rarity','boxHeight','showProbabilityWindow','zIndex','_nextBannerSprite','menu','touchend','opacity','style','BannerHeight','prepareNextScene','BackgroundImage','pause','drawAllItems','isCancelled','#FFFFFF','height','_isProbabilityWindowActive','addChild','2245790lkhUhx','createButtons','contents','TopColor','RewardsReference','drawCircle','addLoadListener','has','46963EPZmbo','rewardAt','Height','createBannerSprite','Unknown\x20Armor','{\x22TopColor\x22:\x20\x22rgba(50,\x2050,\x2050,\x200.8)\x22,\x20\x22BottomColor\x22:\x20\x22rgba(0,\x200,\x200,\x200.2)\x22}','ActivationVariable','getRewardIconIndex','drawIcon','hide','sort','\x22,\x20and\x20the\x20current\x20variable\x20value\x20is:\x20','_pagedownButton','RewardLists','visible','OpenGachaBanner','changeTextColor','name','7500EwBGyA','CustomTexts','bind','backOpacity','rgba(0,\x200,\x200,\x200)','_commandWindow','find','createContents','add','4954050SrBMUr','bitmap','The\x20button\x20\x22','onButtonPress','_probabilityButton','_dimBackground','createHelpWindow','These\x20are\x20the\x20rewards\x20you\x20have\x20obtained:','grantReward','terminate','value','boxWidth','updateTransition','hideProbabilityWindow','item','RarityLevel','removeEventListener','_normalizedRewards','calcWindowHeight','executeButtonAction','paintOpacity','values','_rewards','SceneWindowStyle','No\x20Text','_pendingGachaDraw','TransitionDuration','contentsOpacity','popScene','applyWindowStyle','updateDots','normalizeProbabilities','makeCommandList','appendChild','BannerImage','_rewardWindowStyle','100','shift','iconHeight','duration','NumberOfDraws','startFadeOut','addChildAt','setHandler','black','100%','registerCommand','update','addCommand','drawRewardName','create','touchUI','position','addChildToBack','RewardWindowSettings','_rewardWindow','right','Width','createCancelButton','drawRewardDetails','iconIndex','addWindow','replace','top','width','reverse','isArray','_backgroundImageSprite','fillAll','parse','fontSize','forEach','_dots','BottomColor','setAttribute','drawCustomTexts','match','toString','addEventListener','_customTextWindow','_bannerSprite','7278iFHnFe','Probability','_previousIndex','pageup','_pageupButton','mousedown','_probabilityWindow','_helpWindow','Unknown\x20Item','select','scale','gainItem','_rewardHelpText','_groupRewards','HelpText','_backgroundSprite','Type','setClickHandler','TextColor','controls','Unknown\x20Reward','Rewards','src','handleInput','trim','loadPicture','length','removeChild'];_0x3f47=function(){return _0x324ef1;};return _0x3f47();}(function(_0x3f8a40,_0x55c940){const _0x2484ac=_0x5c0b,_0x128078=_0x3f8a40();while(!![]){try{const _0x3e00c9=-parseInt(_0x2484ac(0x225))/0x1+parseInt(_0x2484ac(0x236))/0x2+-parseInt(_0x2484ac(0x293))/0x3*(-parseInt(_0x2484ac(0x22f))/0x4)+-parseInt(_0x2484ac(0x210))/0x5*(-parseInt(_0x2484ac(0x1ec))/0x6)+parseInt(_0x2484ac(0x281))/0x7*(parseInt(_0x2484ac(0x238))/0x8)+-parseInt(_0x2484ac(0x29c))/0x9+-parseInt(_0x2484ac(0x279))/0xa;if(_0x3e00c9===_0x55c940)break;else _0x128078['push'](_0x128078['shift']());}catch(_0x350e90){_0x128078['push'](_0x128078['shift']());}}}(_0x3f47,0x47c00),((()=>{const _0x4557ce=_0x5c0b,_0x35a6dd=_0x4557ce(0x21d),_0xd96da4=PluginManager['parameters'](_0x35a6dd),_0xdc5982=JSON[_0x4557ce(0x1e0)](_0xd96da4[_0x4557ce(0x20a)]||'[]')[_0x4557ce(0x265)](_0x57b1c1=>{const _0x4ff47f=_0x4557ce,_0x410c53=JSON['parse'](_0x57b1c1);return _0x410c53[_0x4ff47f(0x294)]=JSON[_0x4ff47f(0x1e0)](_0x410c53[_0x4ff47f(0x294)]||'[]')['map'](_0x47e13e=>JSON[_0x4ff47f(0x1e0)](_0x47e13e)),_0x410c53['Buttons']=JSON[_0x4ff47f(0x1e0)](_0x410c53[_0x4ff47f(0x247)]||'[]')[_0x4ff47f(0x265)](_0x579586=>JSON[_0x4ff47f(0x1e0)](_0x579586)),_0x410c53;}),_0x473602=JSON[_0x4557ce(0x1e0)](_0xd96da4[_0x4557ce(0x28e)]||'[]'),_0x3021bc=_0x473602[_0x4557ce(0x265)](_0x412b1d=>{const _0x13ae6d=_0x4557ce,_0x4fc5db=JSON[_0x13ae6d(0x1e0)](_0x412b1d);return _0x4fc5db[_0x13ae6d(0x260)]=_0x4fc5db[_0x13ae6d(0x260)]||'',_0x4fc5db[_0x13ae6d(0x201)]=JSON[_0x13ae6d(0x1e0)](_0x4fc5db[_0x13ae6d(0x201)]||'[]')[_0x13ae6d(0x265)](_0x47365a=>{const _0x4bdf63=_0x13ae6d,_0xb30b72=JSON[_0x4bdf63(0x1e0)](_0x47365a);return _0xb30b72['Type']=_0xb30b72[_0x4bdf63(0x1fc)]||'item',_0xb30b72['ID']=Number(_0xb30b72['ID']||0x1),_0xb30b72['Probability']=Number(_0xb30b72['Probability']||0x32),_0xb30b72;}),_0x4fc5db;}),_0x55ad91=Number(_0xd96da4['BannerWidth']||0x320),_0x2fe5fd=Number(_0xd96da4[_0x4557ce(0x26f)]||0x1c2),_0x4a5934=Number(_0xd96da4[_0x4557ce(0x257)]||0x0),_0x47b353=Number(_0xd96da4[_0x4557ce(0x24c)]||0x0),_0x43841d=Number(_0xd96da4[_0x4557ce(0x241)]||0xa),_0xe5bfde=Number(_0xd96da4['DotSpacing']||0xf),_0x59b4ab=Number(_0xd96da4['DotX']||0x0),_0x53c655=Number(_0xd96da4[_0x4557ce(0x231)]||0x23a),_0x5d03e8=Number(_0xd96da4[_0x4557ce(0x2b6)]||0x1e),_0x407898=JSON[_0x4557ce(0x1e0)](_0xd96da4['ButtonWindowStyle']||'{}'),_0xa2fa3a=Number(_0x407898[_0x4557ce(0x2d5)]||0x64),_0x42af14=Number(_0x407898['Height']||0x19),_0x49bb89=Number(_0x407898['X']||0x0),_0x16df8b=Number(_0x407898['Y']||0x0),_0x428263=Number(_0x407898[_0x4557ce(0x23a)]||0x0),_0x50f081=JSON['parse'](_0x407898[_0x4557ce(0x22c)]||'{}'),_0x51575e=_0x50f081[_0x4557ce(0x27c)]||_0x4557ce(0x24e),_0x23eb88=_0x50f081[_0x4557ce(0x1e4)]||'rgba(0,\x200,\x200,\x200)',_0x1d6c2a=Number(_0xd96da4[_0x4557ce(0x2b3)]||0x0),_0x35231e=JSON['parse'](_0xd96da4[_0x4557ce(0x2d2)]||'{}'),_0x58d5b3=_0x35231e[_0x4557ce(0x1fa)]||_0x4557ce(0x2a3),_0x5e9780=Number(_0x35231e[_0x4557ce(0x23a)]||0x0),_0x3636bf=JSON[_0x4557ce(0x1e0)](_0x35231e['ManualDimSettings']||_0x4557ce(0x286)),_0x3be832=String(_0xd96da4[_0x4557ce(0x271)]||''),_0x44bdc9=JSON[_0x4557ce(0x1e0)](_0xd96da4['ProbabilityWindowSettings']||'{}'),_0x2de8db=Number(_0x44bdc9[_0x4557ce(0x2d5)]||0x32),_0xd16c0f=Number(_0x44bdc9[_0x4557ce(0x283)]||0x32),_0x50fc78=Number(_0x44bdc9['X']||0x19),_0x424519=Number(_0x44bdc9['Y']||0x19),_0x2c78f4=Number(_0x44bdc9[_0x4557ce(0x23a)]||0x0),_0x55fd0e=JSON[_0x4557ce(0x1e0)](_0x44bdc9[_0x4557ce(0x22c)]||'{}'),_0x2bf305=_0x55fd0e[_0x4557ce(0x27c)]||'rgba(0,\x200,\x200,\x200.6)',_0x3ad198=_0x55fd0e[_0x4557ce(0x1e4)]||_0x4557ce(0x297);let _0x2b995f=0x0,_0x216014=_0xdc5982[_0x2b995f],_0x5ee235=![],_0x6762dd=0x0;PluginManager[_0x4557ce(0x2ca)](_0x35a6dd,_0x4557ce(0x290),()=>{const _0x168b52=_0x4557ce;SceneManager[_0x168b52(0x20e)](_0x3bdfd1);});class _0x3bdfd1 extends Scene_MenuBase{[_0x4557ce(0x2ce)](){const _0x327f2c=_0x4557ce;super[_0x327f2c(0x2ce)](),_0x3be832&&_0x3be832['trim']()!==''&&this[_0x327f2c(0x235)](),this[_0x327f2c(0x284)](),this[_0x327f2c(0x24d)](),this[_0x327f2c(0x27a)](),this['createCustomTexts'](),this['applySceneWindowStyle'](),this['_probabilityWindow']=null,this[_0x327f2c(0x277)]=![];}[_0x4557ce(0x235)](){const _0x3c394f=_0x4557ce;_0x3be832&&_0x3be832[_0x3c394f(0x204)]()!==''?(this['_backgroundSprite']=new Sprite(),this['_backgroundSprite'][_0x3c394f(0x29d)]=new Bitmap(Graphics[_0x3c394f(0x1db)],Graphics['height']),this[_0x3c394f(0x1fb)][_0x3c394f(0x29d)][_0x3c394f(0x1df)](_0x3c394f(0x2c8)),this['addChildAt'](this[_0x3c394f(0x1fb)],0x0),this[_0x3c394f(0x1de)]=new Sprite(),this[_0x3c394f(0x1de)]['bitmap']=ImageManager[_0x3c394f(0x205)](_0x3be832),this['_backgroundImageSprite'][_0x3c394f(0x29d)][_0x3c394f(0x27f)](()=>{const _0x275db4=_0x3c394f,_0x478545=Graphics[_0x275db4(0x2a7)]/this['_backgroundImageSprite'][_0x275db4(0x29d)]['width'],_0x2e696c=Graphics[_0x275db4(0x267)]/this[_0x275db4(0x1de)][_0x275db4(0x29d)][_0x275db4(0x276)],_0xe39c9f=Math[_0x275db4(0x23e)](_0x478545,_0x2e696c);this[_0x275db4(0x1de)][_0x275db4(0x1f6)]['x']=_0xe39c9f*1.02,this[_0x275db4(0x1de)][_0x275db4(0x1f6)]['y']=_0xe39c9f*1.02,this['_backgroundImageSprite']['x']=(Graphics[_0x275db4(0x2a7)]-this[_0x275db4(0x1de)][_0x275db4(0x29d)][_0x275db4(0x1db)]*this[_0x275db4(0x1de)][_0x275db4(0x1f6)]['x'])/0x2,this['_backgroundImageSprite']['y']=(Graphics['boxHeight']-this['_backgroundImageSprite'][_0x275db4(0x29d)][_0x275db4(0x276)]*this[_0x275db4(0x1de)][_0x275db4(0x1f6)]['y'])/0x2;}),this[_0x3c394f(0x2c6)](this[_0x3c394f(0x1de)],0x1)):super[_0x3c394f(0x235)]();}[_0x4557ce(0x212)](){const _0x6d6d9d=_0x4557ce;_0x1d6c2a===0x1?(this[_0x6d6d9d(0x1ea)][_0x6d6d9d(0x23c)]=![],this[_0x6d6d9d(0x1ea)][_0x6d6d9d(0x26d)]=0x0,this['_customTextWindow'][_0x6d6d9d(0x296)]=0x0,this[_0x6d6d9d(0x1ea)]['contentsOpacity']=0xff):(this[_0x6d6d9d(0x1ea)][_0x6d6d9d(0x23c)]=!![],this[_0x6d6d9d(0x1ea)][_0x6d6d9d(0x26d)]=0xff,this[_0x6d6d9d(0x1ea)][_0x6d6d9d(0x296)]=0xc0,this[_0x6d6d9d(0x1ea)]['contentsOpacity']=0xff);}['createBannerSprite'](){const _0x2506a6=_0x4557ce;this[_0x2506a6(0x1eb)]=new Sprite(),this[_0x2506a6(0x1eb)][_0x2506a6(0x29d)]=ImageManager['loadPicture'](_0x216014[_0x2506a6(0x2be)]),this[_0x2506a6(0x1eb)][_0x2506a6(0x29d)][_0x2506a6(0x27f)](()=>{const _0x3e99bd=_0x2506a6,_0x5dfeda=_0x55ad91===_0x3e99bd(0x226)?this[_0x3e99bd(0x1eb)][_0x3e99bd(0x29d)]['width']:_0x55ad91,_0x5a56dc=_0x2fe5fd===_0x3e99bd(0x226)?this[_0x3e99bd(0x1eb)][_0x3e99bd(0x29d)]['height']:_0x2fe5fd;_0x55ad91!=='auto'&&(this[_0x3e99bd(0x1eb)][_0x3e99bd(0x1f6)]['x']=_0x5dfeda/this[_0x3e99bd(0x1eb)][_0x3e99bd(0x29d)][_0x3e99bd(0x1db)]),_0x2fe5fd!=='auto'&&(this[_0x3e99bd(0x1eb)]['scale']['y']=_0x5a56dc/this[_0x3e99bd(0x1eb)][_0x3e99bd(0x29d)][_0x3e99bd(0x276)]),this[_0x3e99bd(0x1eb)]['x']=(Graphics[_0x3e99bd(0x2a7)]-_0x5dfeda)/0x2+_0x4a5934,this['_bannerSprite']['y']=(Graphics[_0x3e99bd(0x267)]-_0x5a56dc)/0x2+_0x47b353;}),this[_0x2506a6(0x278)](this[_0x2506a6(0x1eb)]),this[_0x2506a6(0x26a)]=new Sprite(),this[_0x2506a6(0x26a)][_0x2506a6(0x26d)]=0x0,this[_0x2506a6(0x26a)]['x']=this[_0x2506a6(0x1eb)]['x'],this['_nextBannerSprite']['y']=this[_0x2506a6(0x1eb)]['y'],this[_0x2506a6(0x278)](this['_nextBannerSprite']);}[_0x4557ce(0x24d)](){const _0x57f3f4=_0x4557ce;this[_0x57f3f4(0x1e3)]=[];const _0x36d2aa=_0xdc5982[_0x57f3f4(0x206)]*_0x43841d+(_0xdc5982['length']-0x1)*_0xe5bfde,_0x429115=Graphics[_0x57f3f4(0x2a7)]/0x2-_0x36d2aa/0x2+_0x59b4ab,_0x24e022=_0x53c655;for(let _0x7c9c64=0x0;_0x7c9c64<_0xdc5982[_0x57f3f4(0x206)];_0x7c9c64++){const _0x1293e8=new Sprite();_0x1293e8[_0x57f3f4(0x29d)]=new Bitmap(_0x43841d,_0x43841d),_0x1293e8['bitmap'][_0x57f3f4(0x27e)](_0x43841d/0x2,_0x43841d/0x2,_0x43841d/0x2,'#FFFFFF'),_0x1293e8['x']=_0x429115+(_0x43841d+_0xe5bfde)*_0x7c9c64,_0x1293e8['y']=_0x24e022,this[_0x57f3f4(0x278)](_0x1293e8),this[_0x57f3f4(0x1e3)][_0x57f3f4(0x20e)](_0x1293e8);}this['updateDots']();}[_0x4557ce(0x2ba)](){const _0x19ec29=_0x4557ce;for(let _0x216b36=0x0;_0x216b36<this['_dots'][_0x19ec29(0x206)];_0x216b36++){this['_dots'][_0x216b36][_0x19ec29(0x26d)]=_0x216b36===_0x2b995f?0xff:0x80;}}['createCustomTexts'](){const _0x3c4f30=_0x4557ce,_0x3ec94d=new Rectangle(0x0,0x0,Graphics[_0x3c4f30(0x2a7)],Graphics[_0x3c4f30(0x267)]);this[_0x3c4f30(0x1ea)]=new _0x1be927(_0x3ec94d),this['_customTextWindow'][_0x3c4f30(0x25e)](_0x216014[_0x3c4f30(0x294)]),this[_0x3c4f30(0x2d9)](this[_0x3c4f30(0x1ea)]);}[_0x4557ce(0x27a)](){const _0x4ef609=_0x4557ce,_0x4379ef=Graphics[_0x4ef609(0x2a7)]*_0xa2fa3a/0x64,_0x1b420f=Graphics['boxHeight']*_0x42af14/0x64,_0x348f0d=Graphics['boxWidth']*_0x49bb89/0x64,_0x132f3b=Graphics[_0x4ef609(0x267)]*_0x16df8b/0x64,_0x4bb396=new Rectangle(_0x348f0d,_0x132f3b,_0x4379ef,_0x1b420f);this[_0x4ef609(0x298)]&&(this[_0x4ef609(0x207)](this[_0x4ef609(0x298)]),this[_0x4ef609(0x298)]['deactivate'](),this[_0x4ef609(0x298)]['close']()),this[_0x4ef609(0x2a1)]&&this[_0x4ef609(0x207)](this[_0x4ef609(0x2a1)]),_0x428263===0x1&&(this['_dimBackground']=new Sprite(new Bitmap(_0x4379ef,_0x1b420f)),this[_0x4ef609(0x2a1)][_0x4ef609(0x29d)][_0x4ef609(0x24f)](0x0,0x0,_0x4379ef,_0x1b420f,_0x51575e,_0x23eb88,!![]),this[_0x4ef609(0x2a1)]['x']=_0x348f0d,this[_0x4ef609(0x2a1)]['y']=_0x132f3b,this[_0x4ef609(0x278)](this[_0x4ef609(0x2a1)])),this[_0x4ef609(0x298)]=new _0x240e4f(_0x4bb396),this[_0x4ef609(0x2b9)](this[_0x4ef609(0x298)]),setTimeout(()=>{const _0x5814df=_0x4ef609;this['_commandWindow']['setHandler']('ok',this[_0x5814df(0x29f)]['bind'](this)),this[_0x5814df(0x298)]['setHandler'](_0x5814df(0x209),this[_0x5814df(0x2b8)][_0x5814df(0x295)](this)),this['addChild'](this['_commandWindow']),this[_0x5814df(0x298)][_0x5814df(0x253)](_0x216014[_0x5814df(0x247)]),this[_0x5814df(0x298)][_0x5814df(0x23f)]();},0x14),this['createCancelButton'](),this['createPageButtons']();}[_0x4557ce(0x2d6)](){const _0x325ef3=_0x4557ce;!this[_0x325ef3(0x23d)]&&(this[_0x325ef3(0x23d)]=new Sprite_Button(_0x325ef3(0x209)),this[_0x325ef3(0x23d)]['x']=0x4,this[_0x325ef3(0x23d)]['y']=Graphics[_0x325ef3(0x267)]-this['_cancelButton'][_0x325ef3(0x276)]-0x4,this['_cancelButton'][_0x325ef3(0x28f)]=![],this[_0x325ef3(0x278)](this[_0x325ef3(0x23d)]));}[_0x4557ce(0x223)](){const _0x23a063=_0x4557ce;!this[_0x23a063(0x1f0)]&&!this['_pagedownButton']&&(this[_0x23a063(0x1f0)]=new Sprite_Button(_0x23a063(0x217)),this[_0x23a063(0x28d)]=new Sprite_Button(_0x23a063(0x1ef)),this[_0x23a063(0x1f0)]['x']=Graphics[_0x23a063(0x2a7)]-this[_0x23a063(0x1f0)][_0x23a063(0x1db)]-0x4,this[_0x23a063(0x1f0)]['y']=0x4,this[_0x23a063(0x28d)]['x']=0x4,this[_0x23a063(0x28d)]['y']=0x4,this[_0x23a063(0x1f0)]['visible']=![],this[_0x23a063(0x28d)]['visible']=![],this[_0x23a063(0x278)](this[_0x23a063(0x1f0)]),this[_0x23a063(0x278)](this[_0x23a063(0x28d)]),this['_probabilityButton']=new Sprite_Button(_0x23a063(0x26b)),this[_0x23a063(0x2a0)]['x']=Graphics[_0x23a063(0x2a7)]-this['_pageupButton']['width']-this[_0x23a063(0x2a0)]['width']+0x30,this['_probabilityButton']['y']=Graphics['boxHeight']-this[_0x23a063(0x2a0)][_0x23a063(0x276)]-0x4,this[_0x23a063(0x2a0)][_0x23a063(0x28f)]=![],this[_0x23a063(0x278)](this[_0x23a063(0x2a0)]),this['_pageupButton']['setClickHandler'](()=>{const _0x5ebdb2=_0x23a063;!this[_0x5ebdb2(0x277)]&&this[_0x5ebdb2(0x239)](0x1);}),this[_0x23a063(0x28d)][_0x23a063(0x1fd)](()=>{const _0x5b309b=_0x23a063;!this[_0x5b309b(0x277)]&&this[_0x5b309b(0x239)](-0x1);}),this[_0x23a063(0x2a0)][_0x23a063(0x1fd)](()=>{const _0x1bc1c=_0x23a063;!this[_0x1bc1c(0x277)]?this[_0x1bc1c(0x268)]():this[_0x1bc1c(0x2a9)]();}));}[_0x4557ce(0x2b9)](_0x24573){const _0x57181b=_0x4557ce;switch(_0x428263){case 0x1:_0x24573[_0x57181b(0x23c)]=![],_0x24573[_0x57181b(0x26d)]=0x0,_0x24573[_0x57181b(0x296)]=0x0;break;case 0x2:_0x24573[_0x57181b(0x23c)]=![],_0x24573[_0x57181b(0x26d)]=0x0,_0x24573[_0x57181b(0x296)]=0x0,_0x24573[_0x57181b(0x2b7)]=0xff;break;default:_0x24573['frameVisible']=!![],_0x24573[_0x57181b(0x26d)]=0xff,_0x24573[_0x57181b(0x296)]=0xc0,_0x24573[_0x57181b(0x2b7)]=0xff;break;}}[_0x4557ce(0x29f)](){const _0x46a426=_0x4557ce;this['_commandWindow'][_0x46a426(0x21b)]();const _0x196f79=this[_0x46a426(0x298)]['index'](),_0x1dc6da=_0x216014[_0x46a426(0x247)][_0x196f79],_0x4caa19=Number(_0x1dc6da[_0x46a426(0x287)]||0x0),_0x13a157=_0x1dc6da['ConditionalFormula']||'',_0x36d5dc=Number(_0x1dc6da[_0x46a426(0x2c4)]),_0x1f625c=_0x1dc6da['RewardsReference'];let _0x782678=!![];if(_0x4caa19>0x0&&_0x13a157){const _0x22af30=$gameVariables['value'](_0x4caa19);try{_0x782678=eval(_0x22af30+'\x20'+_0x13a157);if(!_0x782678){}}catch(_0x124be5){_0x782678=![];}}if(_0x782678){_0x1dc6da['Actions']&&this[_0x46a426(0x2af)](_0x1dc6da[_0x46a426(0x246)]);const _0x14f34c=_0x3021bc[_0x46a426(0x299)](_0x4d1b96=>_0x4d1b96[_0x46a426(0x260)]===_0x1f625c);if(_0x14f34c){const _0xa17d33=0x1e;this[_0x46a426(0x2c5)](_0xa17d33,![]),this[_0x46a426(0x227)]=!![],this['_pendingGachaDraw']={'rewards':_0x14f34c[_0x46a426(0x201)],'numberOfDraws':_0x36d5dc};}else{}}}[_0x4557ce(0x2af)](_0x3ea011){const _0x4526b9=_0x4557ce,_0x5e06b6=_0x3ea011[_0x4526b9(0x204)](),_0x1f59c0=_0x5e06b6[_0x4526b9(0x1e7)](/variable\((\d+),\s*([+-]?\d+)\)/);if(_0x1f59c0){const _0x24694b=Number(_0x1f59c0[0x1]),_0x2f6288=Number(_0x1f59c0[0x2]),_0x46c4ef=$gameVariables[_0x4526b9(0x2a6)](_0x24694b);$gameVariables['setValue'](_0x24694b,_0x46c4ef+_0x2f6288);}else{}}['performGachaDraw'](_0x469956,_0x3e2a94){const _0x2e7cee=_0x4557ce;let _0x5d4dd1=[],_0x1f8f25=new Set();const _0x4efa79=_0x1fae59=>{const _0x43984e=_0x5c0b,_0x45e2fb=_0x1fae59[_0x43984e(0x22e)]((_0x423cd6,_0x14f6ee)=>_0x423cd6+_0x14f6ee[_0x43984e(0x1ed)],0x0);return _0x1fae59['map'](_0x3939ef=>{const _0x4e6596=_0x43984e;return{..._0x3939ef,'NormalizedProbability':_0x3939ef[_0x4e6596(0x1ed)]/_0x45e2fb*0x64};});},_0x592bfe=_0x392395=>{const _0x3ffdf3=Math['random']()*0x64;let _0x51b4c1=0x0;for(const _0x30fb13 of _0x392395){_0x51b4c1+=_0x30fb13['NormalizedProbability'];if(_0x3ffdf3<=_0x51b4c1)return _0x30fb13;}return _0x392395[_0x392395['length']-0x1];},_0x185984=_0x4efa79(_0x469956);for(let _0x4c2e6b=0x0;_0x4c2e6b<_0x3e2a94;_0x4c2e6b++){const _0x27ef26=_0x592bfe(_0x185984);this[_0x2e7cee(0x2a4)](_0x27ef26),_0x5d4dd1[_0x2e7cee(0x20e)](_0x27ef26),_0x1f8f25[_0x2e7cee(0x29b)](_0x27ef26[_0x2e7cee(0x266)]);}const _0x49090e=JSON[_0x2e7cee(0x1e0)](_0xd96da4[_0x2e7cee(0x215)]||'[]')['map'](_0x49a4c7=>JSON[_0x2e7cee(0x1e0)](_0x49a4c7)),_0x556559=[..._0x1f8f25][_0x2e7cee(0x28b)]()[_0x2e7cee(0x1dc)]()[0x0],_0x13db3c=_0x49090e['find'](_0x3462c6=>_0x3462c6[_0x2e7cee(0x2ab)]===_0x556559);if(_0x13db3c){const _0x324749=_0x13db3c['VideoFile'];this['playRarityVideo'](_0x324749,_0x5d4dd1);}else this[_0x2e7cee(0x208)](_0x5d4dd1);}[_0x4557ce(0x228)](_0x5b1dec,_0x22feae){const _0x1ddf90=_0x4557ce;if(_0x5b1dec&&_0x5b1dec[_0x1ddf90(0x204)]()!==''){const _0x1322a3=_0x5b1dec,_0x581cc4=document['createElement'](_0x1ddf90(0x211));_0x581cc4[_0x1ddf90(0x202)]=_0x1322a3,_0x581cc4[_0x1ddf90(0x21c)]=!![],_0x581cc4[_0x1ddf90(0x25d)]=![],_0x581cc4['volume']=0x1,_0x581cc4[_0x1ddf90(0x1ff)]=![],_0x581cc4[_0x1ddf90(0x26e)][_0x1ddf90(0x2d0)]=_0x1ddf90(0x20c),_0x581cc4['style'][_0x1ddf90(0x1da)]='0',_0x581cc4['style'][_0x1ddf90(0x263)]='0',_0x581cc4['style'][_0x1ddf90(0x1db)]=_0x1ddf90(0x2c9),_0x581cc4[_0x1ddf90(0x26e)]['height']=_0x1ddf90(0x2c9),_0x581cc4[_0x1ddf90(0x26e)][_0x1ddf90(0x269)]=_0x1ddf90(0x2c0),_0x581cc4['style']['objectFit']=_0x1ddf90(0x262),_0x581cc4[_0x1ddf90(0x1e5)](_0x1ddf90(0x25b),''),_0x581cc4[_0x1ddf90(0x1e5)](_0x1ddf90(0x233),''),_0x581cc4[_0x1ddf90(0x26e)][_0x1ddf90(0x26d)]='0',document[_0x1ddf90(0x232)][_0x1ddf90(0x2bd)](_0x581cc4),this['_rewardsToShow']=_0x22feae,SceneManager[_0x1ddf90(0x24a)]=_0x22feae,Input[_0x1ddf90(0x20d)](),this[_0x1ddf90(0x24b)]=!![];let _0x301910=![],_0x3ab896=![],_0x17813c=null,_0x1289f3=![];const _0x3ad4c2=_0x754261=>{const _0x2987e1=_0x1ddf90;_0x754261[_0x2987e1(0x240)]();};document[_0x1ddf90(0x1e9)](_0x1ddf90(0x243),_0x3ad4c2);const _0x401f8c=0x14;let _0x96892f=0x0;const _0x4c4114=()=>{const _0xe4704f=_0x1ddf90;if(_0x3ab896)return;_0x96892f++;const _0x46a495=_0x96892f/_0x401f8c;_0x581cc4[_0xe4704f(0x26e)][_0xe4704f(0x26d)]=_0x46a495[_0xe4704f(0x1e8)](),_0x96892f<_0x401f8c?requestAnimationFrame(_0x4c4114):_0x581cc4[_0xe4704f(0x26e)][_0xe4704f(0x26d)]='1';};_0x4c4114();const _0x24fc4f=()=>{if(_0x1289f3){_0x3ab896=!![];const _0x2e10b0=0x1e;let _0x25fd75=0x0;const _0x11671a=()=>{const _0x2722d9=_0x5c0b;_0x25fd75++;const _0xdf6dbf=0x1-_0x25fd75/_0x2e10b0;_0x581cc4[_0x2722d9(0x26e)][_0x2722d9(0x26d)]=_0xdf6dbf['toString'](),_0x25fd75>=_0x2e10b0?(_0x581cc4[_0x2722d9(0x272)](),_0x581cc4[_0x2722d9(0x250)]=_0x581cc4[_0x2722d9(0x2c3)],_0x79e061()):requestAnimationFrame(_0x11671a);};_0x11671a();}},_0xd3d2ac=()=>{_0x17813c===null&&(_0x1289f3=!![],_0x17813c=setTimeout(_0x24fc4f,0x3e8));},_0x4e318d=()=>{_0x17813c!==null&&(clearTimeout(_0x17813c),_0x17813c=null,_0x1289f3=![]);},_0x24a255=()=>{const _0x51c8d4=_0x1ddf90;if(Input[_0x51c8d4(0x221)]('ok')&&!_0x3ab896){_0x3ab896=!![];const _0x49292b=0x1e;let _0x1d934d=0x0;const _0x39729a=()=>{const _0x254cb4=_0x51c8d4;_0x1d934d++;const _0x50777e=0x1-_0x1d934d/_0x49292b;_0x581cc4[_0x254cb4(0x26e)][_0x254cb4(0x26d)]=_0x50777e[_0x254cb4(0x1e8)](),_0x1d934d>=_0x49292b?(_0x581cc4[_0x254cb4(0x272)](),_0x581cc4[_0x254cb4(0x250)]=_0x581cc4[_0x254cb4(0x2c3)],_0x79e061()):requestAnimationFrame(_0x39729a);};_0x39729a();}},_0x3fa137=setInterval(_0x24a255,0x10);document[_0x1ddf90(0x1e9)](_0x1ddf90(0x1f1),_0xd3d2ac),document['addEventListener']('mouseup',_0x4e318d),document[_0x1ddf90(0x1e9)]('touchstart',_0xd3d2ac),document[_0x1ddf90(0x1e9)]('touchend',_0x4e318d);const _0x79e061=()=>{const _0x44eab9=_0x1ddf90;if(_0x301910)return;_0x301910=!![],clearInterval(_0x3fa137),document[_0x44eab9(0x2ac)](_0x44eab9(0x243),_0x3ad4c2),document[_0x44eab9(0x2ac)](_0x44eab9(0x1f1),_0xd3d2ac),document[_0x44eab9(0x2ac)](_0x44eab9(0x264),_0x4e318d),document['removeEventListener']('touchstart',_0xd3d2ac),document[_0x44eab9(0x2ac)](_0x44eab9(0x26c),_0x4e318d),document[_0x44eab9(0x232)][_0x44eab9(0x224)](_0x581cc4)&&document['body']['removeChild'](_0x581cc4),this['_isVideoPlaying']=![],this[_0x44eab9(0x298)][_0x44eab9(0x23f)](),SceneManager['push'](_0x4eaf80),SceneManager['prepareNextScene'](this[_0x44eab9(0x256)]);};_0x581cc4[_0x1ddf90(0x1e9)](_0x1ddf90(0x21f),()=>{_0x79e061();}),_0x581cc4['onerror']=()=>{_0x79e061();};}else SceneManager[_0x1ddf90(0x20e)](_0x4eaf80),SceneManager[_0x1ddf90(0x270)](_0x22feae),this[_0x1ddf90(0x298)]['activate']();}[_0x4557ce(0x208)](_0x2d83bc){const _0x307e6d=_0x4557ce;if(_0x2d83bc[_0x307e6d(0x206)]>0x0)SceneManager['push'](_0x4eaf80),SceneManager[_0x307e6d(0x270)](_0x2d83bc);else{}}[_0x4557ce(0x2a4)](_0x4ee16b){const _0x155939=_0x4557ce;switch(_0x4ee16b[_0x155939(0x1fc)][_0x155939(0x216)]()){case _0x155939(0x2aa):$gameParty[_0x155939(0x1f7)]($dataItems[_0x4ee16b['ID']],0x1);break;case _0x155939(0x213):$gameParty[_0x155939(0x1f7)]($dataWeapons[_0x4ee16b['ID']],0x1);break;case'armor':$gameParty[_0x155939(0x1f7)]($dataArmors[_0x4ee16b['ID']],0x1);break;default:}}[_0x4557ce(0x2cb)](){const _0x371b79=_0x4557ce;if(this['_isVideoPlaying'])return;super[_0x371b79(0x2cb)]();const _0x2177b6=ConfigManager[_0x371b79(0x2cf)];this[_0x371b79(0x23d)]&&(this[_0x371b79(0x23d)][_0x371b79(0x28f)]=_0x2177b6);this['_pageupButton']&&this[_0x371b79(0x28d)]&&(this[_0x371b79(0x1f0)][_0x371b79(0x28f)]=_0x2177b6&&!this[_0x371b79(0x277)],this['_pagedownButton']['visible']=_0x2177b6&&!this['_isProbabilityWindowActive']);this[_0x371b79(0x2a0)]&&(this[_0x371b79(0x2a0)][_0x371b79(0x28f)]=_0x2177b6&&!this[_0x371b79(0x277)]);if(_0x5ee235)this[_0x371b79(0x2a8)]();else{if(this['_isFadingOut']){if(this[_0x371b79(0x261)]===0x0){this[_0x371b79(0x227)]=![];if(this['_pendingGachaDraw']){const {rewards:_0x2205df,numberOfDraws:_0x1be880}=this[_0x371b79(0x2b5)];this[_0x371b79(0x2b5)]=null,this[_0x371b79(0x252)](_0x2205df,_0x1be880);}}}else this[_0x371b79(0x203)]();}this[_0x371b79(0x277)]&&((Input[_0x371b79(0x221)](_0x371b79(0x209))||TouchInput[_0x371b79(0x274)]())&&this[_0x371b79(0x2a9)]()),Input[_0x371b79(0x221)](_0x371b79(0x2c1))&&(!this[_0x371b79(0x277)]?this['showProbabilityWindow']():this['hideProbabilityWindow']());}[_0x4557ce(0x2a5)](){const _0x3ca33f=_0x4557ce;super[_0x3ca33f(0x2a5)](),this[_0x3ca33f(0x23d)]&&(this['removeChild'](this[_0x3ca33f(0x23d)]),this[_0x3ca33f(0x23d)]=null),this[_0x3ca33f(0x1f0)]&&this[_0x3ca33f(0x28d)]&&(this['removeChild'](this['_pageupButton']),this[_0x3ca33f(0x207)](this[_0x3ca33f(0x28d)]),this[_0x3ca33f(0x1f0)]=null,this[_0x3ca33f(0x28d)]=null);}[_0x4557ce(0x268)](){const _0x3711c9=_0x4557ce,_0x26909d=this['_commandWindow']['index'](),_0x422d71=_0x216014['Buttons'][_0x26909d],_0x48e491=_0x422d71[_0x3711c9(0x27d)],_0x44caa9=_0x3021bc[_0x3711c9(0x299)](_0x48b7bc=>_0x48b7bc[_0x3711c9(0x260)]===_0x48e491);if(_0x44caa9){this[_0x3711c9(0x1eb)][_0x3711c9(0x28f)]=![],this[_0x3711c9(0x298)][_0x3711c9(0x28f)]=![],this['_customTextWindow']['visible']=![],this['_dots'][_0x3711c9(0x1e2)](_0x15f22e=>_0x15f22e[_0x3711c9(0x28f)]=![]);this[_0x3711c9(0x1f0)]&&this['_pagedownButton']&&(this['_pageupButton']['visible']=![],this[_0x3711c9(0x28d)]['visible']=![]);const _0x134c61=this['probabilityWindowRect']();this[_0x3711c9(0x1f2)]=new _0x2921a0(_0x134c61,_0x44caa9[_0x3711c9(0x201)]),this['applyProbabilityWindowStyle'](this[_0x3711c9(0x1f2)]),this[_0x3711c9(0x2d9)](this['_probabilityWindow']),this[_0x3711c9(0x1f2)][_0x3711c9(0x1f5)](0x0),this[_0x3711c9(0x1f2)][_0x3711c9(0x23f)](),this['_isProbabilityWindowActive']=!![],this['_commandWindow']['deactivate'](),this[_0x3711c9(0x1ea)][_0x3711c9(0x21b)]();}}['applyProbabilityWindowStyle'](_0x253130){const _0x2fb5f8=_0x4557ce;switch(_0x2c78f4){case 0x1:_0x253130[_0x2fb5f8(0x23c)]=![],_0x253130[_0x2fb5f8(0x26d)]=0x0,_0x253130['backOpacity']=0x0,this[_0x2fb5f8(0x259)](_0x253130);break;case 0x2:_0x253130[_0x2fb5f8(0x23c)]=![],_0x253130['opacity']=0x0,_0x253130[_0x2fb5f8(0x296)]=0x0;break;default:_0x253130[_0x2fb5f8(0x23c)]=!![],_0x253130[_0x2fb5f8(0x26d)]=0xff,_0x253130[_0x2fb5f8(0x296)]=0xc0;break;}}[_0x4557ce(0x259)](_0x474e6b){const _0x3554bd=_0x4557ce,_0xec304d=_0x2bf305,_0x3ba6fa=_0x3ad198,_0x5069cd=new Bitmap(_0x474e6b['width'],_0x474e6b[_0x3554bd(0x276)]);_0x5069cd[_0x3554bd(0x24f)](0x0,0x0,_0x474e6b[_0x3554bd(0x1db)],_0x474e6b[_0x3554bd(0x276)],_0xec304d,_0x3ba6fa,!![]);const _0x3e5ee9=new Sprite(_0x5069cd);_0x3e5ee9['x']=0x0,_0x3e5ee9['y']=0x0,_0x474e6b[_0x3554bd(0x2d1)](_0x3e5ee9);}[_0x4557ce(0x2a9)](){const _0x2547b9=_0x4557ce;if(this['_probabilityWindow']){this[_0x2547b9(0x1f2)][_0x2547b9(0x28a)](),this[_0x2547b9(0x1f2)][_0x2547b9(0x21b)](),this[_0x2547b9(0x207)](this['_probabilityWindow']),this[_0x2547b9(0x1f2)]=null,this[_0x2547b9(0x277)]=![],this[_0x2547b9(0x1eb)]['visible']=!![],this[_0x2547b9(0x298)][_0x2547b9(0x28f)]=!![],this['_commandWindow']['activate'](),this['_customTextWindow'][_0x2547b9(0x28f)]=!![],this[_0x2547b9(0x1e3)]['forEach'](_0x1bc63c=>_0x1bc63c[_0x2547b9(0x28f)]=!![]);const _0x472ba4=ConfigManager['touchUI'];this[_0x2547b9(0x1f0)]&&this['_pagedownButton']&&(this['_pageupButton']['visible']=_0x472ba4,this['_pagedownButton'][_0x2547b9(0x28f)]=_0x472ba4),this[_0x2547b9(0x2a0)]&&(this[_0x2547b9(0x2a0)][_0x2547b9(0x28f)]=_0x472ba4);}}['probabilityWindowRect'](){const _0x45b08e=_0x4557ce,_0x1b3aa3=Graphics[_0x45b08e(0x2a7)]*_0x2de8db/0x64,_0xf06626=Graphics[_0x45b08e(0x267)]*_0xd16c0f/0x64,_0x2f8a9b=Graphics[_0x45b08e(0x2a7)]*_0x50fc78/0x64,_0x25212e=Graphics[_0x45b08e(0x267)]*_0x424519/0x64;return new Rectangle(_0x2f8a9b,_0x25212e,_0x1b3aa3,_0xf06626);}[_0x4557ce(0x203)](){const _0xf7d695=_0x4557ce;if(this[_0xf7d695(0x277)])return;if(Input[_0xf7d695(0x221)](_0xf7d695(0x263)))this[_0xf7d695(0x239)](-0x1);else Input[_0xf7d695(0x221)](_0xf7d695(0x2d4))&&this[_0xf7d695(0x239)](0x1);}['startTransition'](_0x4b1246){const _0x2e5291=_0x4557ce;_0x5ee235=!![],_0x6762dd=0x0,this[_0x2e5291(0x229)]=_0x4b1246,this[_0x2e5291(0x1ee)]=_0x2b995f,_0x2b995f=(_0x2b995f+_0x4b1246+_0xdc5982['length'])%_0xdc5982[_0x2e5291(0x206)],_0x216014=_0xdc5982[_0x2b995f],this['_nextBannerSprite']['bitmap']=ImageManager[_0x2e5291(0x205)](_0x216014[_0x2e5291(0x2be)]),this[_0x2e5291(0x26a)][_0x2e5291(0x29d)]['addLoadListener'](()=>{const _0x14d07c=_0x2e5291;this['_nextBannerSprite'][_0x14d07c(0x1f6)]['x']=_0x55ad91/this[_0x14d07c(0x26a)][_0x14d07c(0x29d)][_0x14d07c(0x1db)],this[_0x14d07c(0x26a)][_0x14d07c(0x1f6)]['y']=_0x2fe5fd/this[_0x14d07c(0x26a)][_0x14d07c(0x29d)][_0x14d07c(0x276)],this[_0x14d07c(0x26a)][_0x14d07c(0x26d)]=0x0,this[_0x14d07c(0x26a)][_0x14d07c(0x28f)]=![],this[_0x14d07c(0x26a)]['x']=(Graphics[_0x14d07c(0x2a7)]-_0x55ad91)/0x2+_0x4a5934,this['_nextBannerSprite']['y']=(Graphics[_0x14d07c(0x267)]-_0x2fe5fd)/0x2+_0x47b353;});}['updateTransition'](){const _0x56ac91=_0x4557ce;_0x6762dd++;const _0x59a73d=_0x5d03e8/0x2,_0x4bd535=_0x55ad91*0.05,_0x1a81e2=this[_0x56ac91(0x229)];if(_0x6762dd<=_0x59a73d){const _0xcbc658=_0x6762dd/_0x59a73d,_0xa460e7=_0x4bd535*_0xcbc658*_0x1a81e2;this[_0x56ac91(0x1eb)][_0x56ac91(0x26d)]=0xff*(0x1-_0xcbc658),this[_0x56ac91(0x1eb)]['x']=(Graphics[_0x56ac91(0x2a7)]-_0x55ad91)/0x2+_0x4a5934+_0xa460e7;}else{!this[_0x56ac91(0x26a)][_0x56ac91(0x28f)]&&(this[_0x56ac91(0x26a)][_0x56ac91(0x28f)]=!![]);const _0x1f5d4b=(_0x6762dd-_0x59a73d)/_0x59a73d,_0x3ab5c0=_0x4bd535*(0x1-_0x1f5d4b)*_0x1a81e2;this[_0x56ac91(0x26a)][_0x56ac91(0x26d)]=0xff*_0x1f5d4b,this['_nextBannerSprite']['x']=(Graphics[_0x56ac91(0x2a7)]-_0x55ad91)/0x2+_0x4a5934+_0x3ab5c0;}_0x6762dd>=_0x5d03e8&&(_0x5ee235=![],this['_bannerSprite']['bitmap']=this[_0x56ac91(0x26a)][_0x56ac91(0x29d)],this[_0x56ac91(0x1eb)]['x']=(Graphics[_0x56ac91(0x2a7)]-_0x55ad91)/0x2+_0x4a5934,this[_0x56ac91(0x1eb)][_0x56ac91(0x26d)]=0xff,this[_0x56ac91(0x26a)][_0x56ac91(0x26d)]=0x0,this[_0x56ac91(0x26a)][_0x56ac91(0x28f)]=![],this['updateDots'](),_0x216014=_0xdc5982[_0x2b995f],this[_0x56ac91(0x1ea)]['setCustomTexts'](_0x216014[_0x56ac91(0x294)]),this['createButtons']());}}class _0x1be927 extends Window_Base{['initialize'](_0x9fd328){const _0x5961fc=_0x4557ce;super['initialize'](_0x9fd328),this[_0x5961fc(0x254)]=[],this[_0x5961fc(0x23c)]=!![],this[_0x5961fc(0x26d)]=0x0,this[_0x5961fc(0x296)]=0x0,this[_0x5961fc(0x2b7)]=0xff;}[_0x4557ce(0x25e)](_0x1b0a94){const _0xd6b7e7=_0x4557ce;this[_0xd6b7e7(0x254)]=_0x1b0a94,this['refresh']();}[_0x4557ce(0x23b)](){const _0x2c65e1=_0x4557ce;this[_0x2c65e1(0x27b)][_0x2c65e1(0x20d)](),this[_0x2c65e1(0x1e6)]();}[_0x4557ce(0x1e6)](){const _0x5858cf=_0x4557ce;this[_0x5858cf(0x254)]['forEach'](_0x1c89dc=>{const _0x141588=_0x5858cf;let _0xfbcfa9=_0x1c89dc[_0x141588(0x25a)]||'';const _0x189fa8=_0x1c89dc['Color']||_0x141588(0x275),_0x3002fa=Number(_0x1c89dc[_0x141588(0x230)]||0x18),_0x146784=Number(_0x1c89dc[_0x141588(0x22b)]||0x0),_0x42dfd=Number(_0x1c89dc['OffsetY']||0x0);_0xfbcfa9=this[_0x141588(0x248)](_0xfbcfa9),this[_0x141588(0x27b)][_0x141588(0x1e1)]=_0x3002fa,this[_0x141588(0x291)](_0x189fa8),this[_0x141588(0x237)](_0xfbcfa9,_0x146784,_0x42dfd,this['contentsWidth'](),'center');});}[_0x4557ce(0x248)](_0x2a1743){const _0x6a8ba2=_0x4557ce;return _0x2a1743=_0x2a1743['replace'](/\\/g,'\x1b'),_0x2a1743=_0x2a1743['replace'](/\x1b\x1b/g,'\x5c'),_0x2a1743=_0x2a1743[_0x6a8ba2(0x1d9)](/\x1bV\[(\d+)\]/gi,(_0x2d551a,_0x105806)=>$gameVariables['value'](Number(_0x105806))),_0x2a1743;}[_0x4557ce(0x2cb)](){const _0x4f4e33=_0x4557ce;super[_0x4f4e33(0x2cb)](),this[_0x4f4e33(0x23b)]();}}class _0x240e4f extends Window_Command{constructor(_0x340992){const _0x4fa8e6=_0x4557ce;super(_0x340992),this[_0x4fa8e6(0x255)]=[];}[_0x4557ce(0x253)](_0x4bd3c0){const _0x3394c0=_0x4557ce;this[_0x3394c0(0x255)]=Array[_0x3394c0(0x1dd)](_0x4bd3c0)?_0x4bd3c0:[],this['refresh']();}[_0x4557ce(0x23b)](){const _0x1879d4=_0x4557ce;this['clearCommandList'](),this[_0x1879d4(0x2bc)](),this[_0x1879d4(0x27b)][_0x1879d4(0x20d)](),this[_0x1879d4(0x29a)](),this[_0x1879d4(0x273)]();}['makeCommandList'](){const _0x3ea868=_0x4557ce;this[_0x3ea868(0x255)]&&this[_0x3ea868(0x255)][_0x3ea868(0x206)]>0x0&&this['_buttons'][_0x3ea868(0x1e2)](_0x2bfc4a=>{const _0x325796=_0x3ea868,_0x111991=Number(_0x2bfc4a[_0x325796(0x287)]||0x0),_0x24cfc1=_0x2bfc4a['ConditionalFormula']||'';let _0x455d47=!![],_0x333280='';if(_0x111991>0x0&&_0x24cfc1){const _0xefa9a7=$gameVariables['value'](_0x111991);try{_0x455d47=eval(_0xefa9a7+'\x20'+_0x24cfc1),!_0x455d47&&(_0x333280=_0x325796(0x29e)+_0x2bfc4a['Text']+'\x22\x20is\x20not\x20available\x20because\x20its\x20condition\x20is:\x20\x22'+_0xefa9a7+'\x20'+_0x24cfc1+_0x325796(0x28c)+_0xefa9a7);}catch(_0x151d17){_0x455d47=![],_0x333280='Error\x20in\x20Conditional\x20Formula\x20for\x20the\x20button\x20\x22'+_0x2bfc4a[_0x325796(0x25a)]+'\x22';}}if(!_0x455d47&&_0x333280){}this[_0x325796(0x2cc)](_0x2bfc4a[_0x325796(0x25a)],'ok',_0x455d47);});}[_0x4557ce(0x222)](_0x164093){const _0x2fc9e9=_0x4557ce,_0x1a8ea=this['_buttons'][_0x164093],_0x363a9d=this['itemRect'](_0x164093),_0x4ac7ed=_0x1a8ea[_0x2fc9e9(0x1fe)]||_0x2fc9e9(0x275),_0x30063b=_0x1a8ea[_0x2fc9e9(0x25a)]||_0x2fc9e9(0x2b4),_0x59b9ff=this[_0x2fc9e9(0x20f)](_0x164093),_0x2cbc21=0x8;this[_0x2fc9e9(0x219)](_0x59b9ff),this[_0x2fc9e9(0x27b)]['clearRect'](_0x363a9d['x'],_0x363a9d['y'],_0x363a9d[_0x2fc9e9(0x1db)],_0x363a9d['height']),this[_0x2fc9e9(0x27b)][_0x2fc9e9(0x2b0)]=_0x59b9ff?0xff:0x80,this['changeTextColor'](_0x4ac7ed),this[_0x2fc9e9(0x237)](_0x30063b,_0x363a9d['x']+_0x2cbc21,_0x363a9d['y'],_0x363a9d[_0x2fc9e9(0x1db)]-_0x2cbc21*0x2,'center'),this[_0x2fc9e9(0x219)](!![]);}}SceneManager[_0x4557ce(0x270)]=function(_0x493984){const _0x416f5f=_0x4557ce;this[_0x416f5f(0x24a)]=_0x493984;};class _0x4eaf80 extends Scene_MenuBase{[_0x4557ce(0x2ce)](){const _0x1f96b9=_0x4557ce;super[_0x1f96b9(0x2ce)](),_0x3be832&&_0x3be832[_0x1f96b9(0x204)]()!==''&&this[_0x1f96b9(0x235)](),this['_rewards']=SceneManager[_0x1f96b9(0x24a)]?this[_0x1f96b9(0x1f9)](SceneManager[_0x1f96b9(0x24a)]):[],this[_0x1f96b9(0x1f8)]=_0x58d5b3,this[_0x1f96b9(0x2bf)]=_0x5e9780,this[_0x1f96b9(0x22d)]=_0x3636bf,this[_0x1f96b9(0x2a2)](),this['createRewardWindow']();}[_0x4557ce(0x249)](){const _0x980aaf=_0x4557ce;super[_0x980aaf(0x249)]();const _0x22a465=0x19;this[_0x980aaf(0x22a)](_0x22a465,![]);}[_0x4557ce(0x235)](){const _0x1e49ad=_0x4557ce;_0x3be832&&_0x3be832[_0x1e49ad(0x204)]()!==''?(this[_0x1e49ad(0x1fb)]=new Sprite(),this['_backgroundSprite'][_0x1e49ad(0x29d)]=new Bitmap(Graphics[_0x1e49ad(0x1db)],Graphics['height']),this[_0x1e49ad(0x1fb)][_0x1e49ad(0x29d)][_0x1e49ad(0x1df)](_0x1e49ad(0x2c8)),this['addChildAt'](this['_backgroundSprite'],0x0),this[_0x1e49ad(0x1de)]=new Sprite(),this[_0x1e49ad(0x1de)]['bitmap']=ImageManager[_0x1e49ad(0x205)](_0x3be832),this[_0x1e49ad(0x1de)]['bitmap'][_0x1e49ad(0x27f)](()=>{const _0x407f5b=_0x1e49ad,_0x1eed50=Graphics['boxWidth']/this[_0x407f5b(0x1de)][_0x407f5b(0x29d)][_0x407f5b(0x1db)],_0x1b4abd=Graphics[_0x407f5b(0x267)]/this['_backgroundImageSprite'][_0x407f5b(0x29d)][_0x407f5b(0x276)],_0x53c308=Math[_0x407f5b(0x23e)](_0x1eed50,_0x1b4abd);this[_0x407f5b(0x1de)][_0x407f5b(0x1f6)]['x']=_0x53c308*1.02,this[_0x407f5b(0x1de)]['scale']['y']=_0x53c308*1.02,this[_0x407f5b(0x1de)]['x']=(Graphics[_0x407f5b(0x2a7)]-this['_backgroundImageSprite']['width']*this[_0x407f5b(0x1de)][_0x407f5b(0x1f6)]['x'])/0x2,this['_backgroundImageSprite']['y']=(Graphics[_0x407f5b(0x267)]-this[_0x407f5b(0x1de)][_0x407f5b(0x276)]*this['_backgroundImageSprite'][_0x407f5b(0x1f6)]['y'])/0x2;}),this['addChildAt'](this[_0x1e49ad(0x1de)],0x1)):super['createBackground']();}[_0x4557ce(0x1f9)](_0x56a80f){const _0x36da27=_0x4557ce,_0x43dd3b=new Map();return _0x56a80f[_0x36da27(0x1e2)](_0x3d6dc9=>{const _0x412a6a=_0x36da27,_0x1a6efc=_0x3d6dc9[_0x412a6a(0x1fc)]+'_'+_0x3d6dc9['ID'];_0x43dd3b[_0x412a6a(0x280)](_0x1a6efc)?_0x43dd3b[_0x412a6a(0x218)](_0x1a6efc)['quantity']+=0x1:_0x43dd3b[_0x412a6a(0x245)](_0x1a6efc,{..._0x3d6dc9,'quantity':0x1});}),Array['from'](_0x43dd3b[_0x36da27(0x2b1)]());}[_0x4557ce(0x2a2)](){const _0x418115=_0x4557ce,_0x13792e=this[_0x418115(0x220)]();this[_0x418115(0x1f3)]=new Window_Help(_0x13792e),this['_helpWindow'][_0x418115(0x258)](_0x58d5b3),this[_0x418115(0x2d9)](this['_helpWindow']),this[_0x418115(0x2b9)](this[_0x418115(0x1f3)],_0x5e9780);}[_0x4557ce(0x220)](){const _0x127dd9=_0x4557ce,_0x2dde2f=0x14,_0x44d69e=0x14,_0xdca036=Graphics[_0x127dd9(0x2a7)]-0x28,_0x2f8918=this[_0x127dd9(0x2ae)](0x1,![]);return new Rectangle(_0x2dde2f,_0x44d69e,_0xdca036,_0x2f8918);}['createRewardWindow'](){const _0xc68f5=_0x4557ce,_0x512dac=this[_0xc68f5(0x25c)]();this[_0xc68f5(0x2d3)]=new _0x3c4e2c(_0x512dac,this[_0xc68f5(0x2b2)]),this['_rewardWindow'][_0xc68f5(0x2c7)](_0xc68f5(0x209),this[_0xc68f5(0x2b8)][_0xc68f5(0x295)](this)),this[_0xc68f5(0x2d3)]['activate'](),this['applyWindowStyle'](this[_0xc68f5(0x2d3)],_0x5e9780),this[_0xc68f5(0x2d9)](this[_0xc68f5(0x2d3)]);}[_0x4557ce(0x25c)](){const _0x1c6f85=_0x4557ce,_0x23451c=0x14,_0x5a4bba=this[_0x1c6f85(0x1f3)][_0x1c6f85(0x276)]+0x28,_0x49ea09=Graphics['boxWidth']-0x28,_0x1ab566=Graphics[_0x1c6f85(0x267)]-_0x5a4bba-0x14;return new Rectangle(_0x23451c,_0x5a4bba,_0x49ea09,_0x1ab566);}[_0x4557ce(0x2b9)](_0x2a1ead,_0x169da6){const _0x21fd17=_0x4557ce;switch(_0x169da6){case 0x1:_0x2a1ead['setBackgroundType'](0x2),_0x2a1ead[_0x21fd17(0x23c)]=![],this[_0x21fd17(0x234)](_0x2a1ead);break;case 0x2:_0x2a1ead[_0x21fd17(0x244)](0x2),_0x2a1ead[_0x21fd17(0x23c)]=![];break;default:_0x2a1ead[_0x21fd17(0x244)](0x0),_0x2a1ead[_0x21fd17(0x23c)]=!![];break;}}[_0x4557ce(0x234)](_0x5bd0fa){const _0x1395a1=_0x4557ce,_0x4827ab=_0x3636bf[_0x1395a1(0x27c)],_0x437b75=_0x3636bf[_0x1395a1(0x1e4)],_0x2188ca=new Bitmap(_0x5bd0fa['width'],_0x5bd0fa[_0x1395a1(0x276)]);_0x2188ca[_0x1395a1(0x24f)](0x0,0x0,_0x5bd0fa[_0x1395a1(0x1db)],_0x5bd0fa[_0x1395a1(0x276)],_0x4827ab,_0x437b75,!![]);const _0x4e3883=new Sprite(_0x2188ca);_0x4e3883['x']=0x0,_0x4e3883['y']=0x0,_0x5bd0fa[_0x1395a1(0x2c6)](_0x4e3883,0x0);}}class _0x3c4e2c extends Window_Selectable{constructor(_0x660181,_0x1736b6){const _0x59dd85=_0x4557ce;super(_0x660181),this['_rewards']=_0x1736b6||[],this[_0x59dd85(0x23b)](),this[_0x59dd85(0x1f5)](0x0);}[_0x4557ce(0x21a)](){const _0x3aa515=_0x4557ce;return this[_0x3aa515(0x2b2)]['length'];}[_0x4557ce(0x282)](_0x5a7481){const _0x2b54b6=_0x4557ce;return this[_0x2b54b6(0x2b2)][_0x5a7481];}[_0x4557ce(0x222)](_0x75fcbd){const _0x34e841=_0x4557ce,_0x5d4fb9=this['rewardAt'](_0x75fcbd);if(_0x5d4fb9){const _0x3bcc56=this['itemRect'](_0x75fcbd);this[_0x34e841(0x25f)](_0x5d4fb9,_0x3bcc56),this[_0x34e841(0x2cd)](_0x5d4fb9,_0x3bcc56);}}[_0x4557ce(0x25f)](_0x3f9622,_0x331da5){const _0x3b6e0b=_0x4557ce,_0x4fb9ef=_0x331da5['x']+0xa,_0x4ab902=_0x331da5['y']+(_0x331da5[_0x3b6e0b(0x276)]-ImageManager[_0x3b6e0b(0x2c2)])/0x2,_0x1c87a7=this[_0x3b6e0b(0x288)](_0x3f9622);this['drawIcon'](_0x1c87a7,_0x4fb9ef,_0x4ab902);}[_0x4557ce(0x2cd)](_0x5d3248,_0x3932d5){const _0x3950fa=_0x4557ce,_0x2fa742=_0x3932d5['x']+0x30,_0x4ecffb=_0x3932d5['y'],_0x4bf365='x'+_0x5d3248['quantity'],_0x467690=this[_0x3950fa(0x242)](_0x5d3248),_0x15c891=_0x3932d5[_0x3950fa(0x1db)]-_0x2fa742-0xa;this[_0x3950fa(0x237)](_0x467690,_0x2fa742,_0x4ecffb,_0x15c891-this[_0x3950fa(0x214)](_0x4bf365)-0xa,_0x3950fa(0x263)),this['drawText'](_0x4bf365,_0x2fa742,_0x4ecffb,_0x15c891,_0x3950fa(0x2d4));}[_0x4557ce(0x242)](_0x4252a5){const _0x584fcc=_0x4557ce;switch(_0x4252a5[_0x584fcc(0x1fc)]['toLowerCase']()){case _0x584fcc(0x2aa):return $dataItems[_0x4252a5['ID']]?$dataItems[_0x4252a5['ID']]['name']:_0x584fcc(0x1f4);case _0x584fcc(0x213):return $dataWeapons[_0x4252a5['ID']]?$dataWeapons[_0x4252a5['ID']][_0x584fcc(0x292)]:'Unknown\x20Weapon';case _0x584fcc(0x20b):return $dataArmors[_0x4252a5['ID']]?$dataArmors[_0x4252a5['ID']][_0x584fcc(0x292)]:'Unknown\x20Armor';default:return _0x584fcc(0x200);}}[_0x4557ce(0x288)](_0x2c0ac5){const _0x38cc00=_0x4557ce;switch(_0x2c0ac5['Type'][_0x38cc00(0x216)]()){case _0x38cc00(0x2aa):return $dataItems[_0x2c0ac5['ID']]?$dataItems[_0x2c0ac5['ID']]['iconIndex']:0x0;case'weapon':return $dataWeapons[_0x2c0ac5['ID']]?$dataWeapons[_0x2c0ac5['ID']][_0x38cc00(0x2d8)]:0x0;case'armor':return $dataArmors[_0x2c0ac5['ID']]?$dataArmors[_0x2c0ac5['ID']][_0x38cc00(0x2d8)]:0x0;default:return 0x0;}}}class _0x2921a0 extends Window_Selectable{constructor(_0x4dbda1,_0x54e3c3){const _0x2a9c25=_0x4557ce;super(_0x4dbda1),this[_0x2a9c25(0x2b2)]=_0x54e3c3||[],this[_0x2a9c25(0x2ad)]=this['normalizeProbabilities'](this[_0x2a9c25(0x2b2)]),this['refresh']();}[_0x4557ce(0x21a)](){const _0x23c465=_0x4557ce;return this[_0x23c465(0x2ad)][_0x23c465(0x206)];}[_0x4557ce(0x2bb)](_0x5637cb){const _0x2799e2=_0x4557ce,_0x5e187f=_0x5637cb[_0x2799e2(0x22e)]((_0x348800,_0x34bcd5)=>_0x348800+_0x34bcd5['Probability'],0x0);return _0x5637cb[_0x2799e2(0x265)](_0x312948=>{const _0x31339e=_0x2799e2;return{..._0x312948,'NormalizedProbability':(_0x312948[_0x31339e(0x1ed)]/_0x5e187f*0x64)['toFixed'](0x2)};});}['drawItem'](_0x5715b8){const _0x53dc0d=_0x4557ce,_0x164aac=this[_0x53dc0d(0x2ad)][_0x5715b8];if(_0x164aac){const _0x5cee19=this[_0x53dc0d(0x21e)](_0x5715b8);this[_0x53dc0d(0x25f)](_0x164aac,_0x5cee19),this[_0x53dc0d(0x2d7)](_0x164aac,_0x5cee19);}}[_0x4557ce(0x25f)](_0x3f0fd3,_0x50cc9c){const _0x4585dc=_0x4557ce,_0x4a6366=_0x50cc9c['x']+0xa,_0x1d14c6=_0x50cc9c['y']+(_0x50cc9c[_0x4585dc(0x276)]-ImageManager[_0x4585dc(0x2c2)])/0x2,_0x562778=this[_0x4585dc(0x288)](_0x3f0fd3);this[_0x4585dc(0x289)](_0x562778,_0x4a6366,_0x1d14c6);}[_0x4557ce(0x2d7)](_0xdc44de,_0x3b2123){const _0x1085d5=_0x4557ce,_0x254b25=_0x3b2123['x']+0x30,_0x43c6bc=_0x3b2123['y'],_0x3da773=this[_0x1085d5(0x242)](_0xdc44de),_0x1eefc3=_0xdc44de['NormalizedProbability']+'%',_0xdbd8bf=_0x3b2123['width']-_0x254b25-0xa;this[_0x1085d5(0x237)](_0x3da773,_0x254b25,_0x43c6bc,_0xdbd8bf-this[_0x1085d5(0x214)](_0x1eefc3)-0xa,_0x1085d5(0x263)),this['drawText'](_0x1eefc3,_0x254b25,_0x43c6bc,_0xdbd8bf,'right');}[_0x4557ce(0x242)](_0x1bfaaa){const _0x10743f=_0x4557ce;switch(_0x1bfaaa[_0x10743f(0x1fc)][_0x10743f(0x216)]()){case'item':return $dataItems[_0x1bfaaa['ID']]?$dataItems[_0x1bfaaa['ID']][_0x10743f(0x292)]:_0x10743f(0x1f4);case _0x10743f(0x213):return $dataWeapons[_0x1bfaaa['ID']]?$dataWeapons[_0x1bfaaa['ID']][_0x10743f(0x292)]:_0x10743f(0x251);case _0x10743f(0x20b):return $dataArmors[_0x1bfaaa['ID']]?$dataArmors[_0x1bfaaa['ID']][_0x10743f(0x292)]:_0x10743f(0x285);default:return'Unknown\x20Reward';}}[_0x4557ce(0x288)](_0x1cd697){const _0x3e3f1d=_0x4557ce;switch(_0x1cd697['Type'][_0x3e3f1d(0x216)]()){case _0x3e3f1d(0x2aa):return $dataItems[_0x1cd697['ID']]?$dataItems[_0x1cd697['ID']][_0x3e3f1d(0x2d8)]:0x0;case'weapon':return $dataWeapons[_0x1cd697['ID']]?$dataWeapons[_0x1cd697['ID']][_0x3e3f1d(0x2d8)]:0x0;case'armor':return $dataArmors[_0x1cd697['ID']]?$dataArmors[_0x1cd697['ID']]['iconIndex']:0x0;default:return 0x0;}}}})()));